<?php
// Start the session
session_start();

// Check if the user is logged in by checking the session variables
if (isset($_SESSION['user_id']) && isset($_SESSION['username'])) {
    // Get user ID from the session
    $user_id = $_SESSION['user_id'];

    // Include the database connection file
    include("db.php");

    // Get current date and time for the Out_Time and Out_Date
    $out_date = date('Y-m-d');  // Get current date in 'Y-m-d' format

    // Prepare and execute the query to update Out_Time and Out_Date in the sign_in table
    $updateSignInSql = "UPDATE sign_in 
                        SET Out_Time = NOW(), Out_Date = '$out_date' 
                        WHERE User_id = '$user_id' AND Out_Time IS NULL";

    // Prepare the query to update Remember_token in the user_login table
    $updateRememberTokenSql = "UPDATE user_login 
                               SET Remember_token = '' 
                               WHERE Id = '$user_id'";

    // Execute both queries
    $signInUpdated = $conn->query($updateSignInSql);
    $tokenUpdated = $conn->query($updateRememberTokenSql);

    if ($signInUpdated === TRUE && $tokenUpdated === TRUE) {
        // Both updates were successful, destroy the session
        session_unset();  // Remove all session variables
        session_destroy(); // Destroy the session

        // Send success response
        echo json_encode(['status' => 'success', 'message' => 'Logged out successfully']);
    } else {
        // If there's an error updating the sign_in or user_login table
        $errorMsg = "Failed to update sign-in or logout data.";
        if ($signInUpdated !== TRUE) {
            $errorMsg = "Failed to update sign-in data.";
        } elseif ($tokenUpdated !== TRUE) {
            $errorMsg = "Failed to update logout token.";
        }
        echo json_encode(['status' => 'error', 'message' => $errorMsg]);
    }
} else {
    // If the user is not logged in
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
}

// Close the database connection
$conn->close();
?>
